<?php
header('Content-type: application/json');

// ============= تنظیمات کش =============
$cache_file = 'cache.json';
$cache_time = 62 * 60;

if (!file_exists($cache_file) || (time() - filemtime($cache_file)) > $cache_time) {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://api-breakk.vetramain.com/app/?action=app_data_slice',
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $response = json_decode(curl_exec($curl), true)['result']['free_servers'];
    curl_close($curl);

    $configs = [];
    foreach ($response as $value) {
        $p = base64_decode($value['vpn_server_config']);
        $s = openssl_decrypt($p, 'AES-256-ECB', hex2bin('ce0f2868988e8d90c1b58cc73c50c067e6a590508df2faa1cf0eec88de422b52'), OPENSSL_RAW_DATA);
        if ($s) {
            $configs[] = $s;
        }
    }

    file_put_contents($cache_file, json_encode($configs));
}

// ============= خواندن از کش و چاپ یکی از کانفیگ‌ها =============
$cached_configs = json_decode(file_get_contents($cache_file), true);

$index_file = 'index.txt';
$index = file_exists($index_file) ? intval(file_get_contents($index_file)) : 0;

if (!empty($cached_configs)) {
    $raw = $cached_configs[$index % count($cached_configs)];

    // تبدیل escape شده به رشته‌ی خوانا
    $unescaped = stripcslashes($raw);

    // تبدیل به آرایه PHP
    $decoded = json_decode($unescaped, true);

    if ($decoded) {
        echo json_encode($decoded, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode(["error" => "Could not decode JSON after unescaping"]);
    }

    file_put_contents($index_file, ($index + 1));
} else {
    echo json_encode(["error" => "No valid configs"]);
}