<?php
header('Content-type: application/json');
function decrypt_config($config_code, $token, $key_str) {
    $bytes = $key_str . $token;
    $key = hash('sha256', $bytes, true);
    $decode = base64_decode($config_code);
    $nonce = substr($decode, 0, 12);
    $tag = substr($decode, -16);
    $ciphertext = substr($decode, 12, -16);

    $plaintext = openssl_decrypt($ciphertext,'aes-256-gcm',$key,OPENSSL_RAW_DATA,$nonce,$tag);

    return $plaintext !== false ? $plaintext : '';
}


function generateRandomDeviceId($length) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
    $randomString = '';

    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}
function jsonserver($vlessJson,$name = 'nima'){ 
    $decoded_data = json_decode($vlessJson); 
    if($decoded_data !== null) {
        $data = json_decode($vlessJson, true); 
        $protocol = $data['outbounds'][0]['protocol']; 
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id']; 
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address']; 
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port']; 
        $security = $data['outbounds'][0]['streamSettings']['security']; 
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn']; 
        $type = $data['outbounds'][0]['streamSettings']['network']; 
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host']; 
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path']; 
        if($protocol == 'vless'){
            $v2ary_vless = "vless://{$uuid}@{$address}:{$port}?encryption=none&security={$security}&sni={$tlsSخni}&type={$type}&alpn={$alpn['0']}{$alpn['1']}&host={$host}&path={$path}#".$data['remarks']; 
            return $v2ary_vless."  \n\n";
        }else{
            $v2ary_vmess = 'vmess://'.base64_encode('{"add":"'.$address.'","aid":"0","alpn":"'.$alpn['0'].$alpn['1'].'","fp":"","host":"","id":"'.$uuid.'","net":"'.$type.'","path":"'.$path.'","port":"'.$port.'","ps":"new server","scy":"auto","sni":"'.$tlsSni.'","tls":"","type":"'.$type.'","v":"2"}');
            return $v2ary_vmess."  \n\n";
        }
    }else{
        return $vlessJson."  \n\n"; 
    }
}
//===================
$headers = [
    'Content-Type: application/x-www-form-urlencoded; charset=UTF-8',
    'User-Agent: Dalvik/2.1.0 (Linux; U; Android 9; ROG Phone 7 Ultimate Build/PQ3B.190801.12191611)',
];
//===============
$s = generateRandomDeviceId(16);
$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => 'https://lib2023.site/vping/load_data.php',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 'assets_folder_file_ist=%D9%81%D8%A7%DB%8C%D9%84%E2%80%8C%D9%87%D8%A7%DB%8C+%D9%85%D9%88%D8%AC%D9%88%D8%AF+%D8%AF%D8%B1+assets%3A%0Acustom_routing_black%0Acustom_routing_global%0Acustom_routing_white%0Acustom_routing_white_iran%0Adexopt%0Ageoip.dat%0Ageosite.dat%0Aimages%0Aopen_source_licenses.html%0Aproxy_packagename.txt%0Av2ray_config.json%0Awebkit%0A&activity_name=MainActivity&signature=e9cd38372b29b1fc1a51030ec00a9eee585176c315f0619f12864d5fe7a021ab&token_key_temp=&os_version=9&token_key=pAd4dd32Ssarr1&hajmi=&manifest_permission_list=Permissions%3A%0Acom.google.android.gms.permission.AD_ID%0Aandroid.permission.QUERY_ALL_PACKAGES%0Aandroid.permission.ACCESS_NETWORK_STATE%0Aandroid.permission.CHANGE_NETWORK_STATE%0Aandroid.permission.INTERNET%0Aandroid.permission.FOREGROUND_SERVICE%0Aandroid.permission.FOREGROUND_SERVICE_SPECIAL_USE%0Aandroid.permission.POST_NOTIFICATIONS%0Aandroid.permission.RECEIVE_BOOT_COMPLETED%0Aandroid.permission.WAKE_LOCK%0Acom.google.android.c2dm.permission.RECEIVE%0Acom.google.android.finsky.permission.BIND_GET_INSTALL_REFERRER_SERVICE%0Aandroid.permission.ACCESS_ADSERVICES_ATTRIBUTION%0Aandroid.permission.ACCESS_ADSERVICES_AD_ID%0Acom.v2ray.warpi.DYNAMIC_RECEIVER_NOT_EXPORTED_PERMISSION%0A%0AActivities%3A%0Acom.v2ray.warpi.ui.SplashScreen%0Acom.v2ray.warpi.ui.ServerActivity%0Acom.v2ray.warpi.ui.ServerCustomConfigActivity%0Acom.v2ray.warpi.ui.SettingsActivity%0Acom.v2ray.warpi.ui.PerAppProxyActivity%0Acom.v2ray.warpi.ui.ScannerActivity%0Acom.v2ray.warpi.ui.LogcatActivity%0Acom.v2ray.warpi.ui.RoutingSettingActivity%0Acom.v2ray.warpi.ui.RoutingEditActivity%0Acom.v2ray.warpi.ui.SubSettingActivity%0Acom.v2ray.warpi.ui.UserAssetActivity%0Acom.v2ray.warpi.ui.UserAssetUrlActivity%0Acom.v2ray.warpi.ui.SubEditActivity%0Acom.v2ray.warpi.ui.ScScannerActivity%0Acom.v2ray.warpi.ui.ScSwitchActivity%0Acom.v2ray.warpi.ui.UrlSchemeActivity%0Acom.v2ray.warpi.ui.AboutActivity%0Acom.v2ray.warpi.ui.TaskerActivity%0Acom.v2ray.warpi.ui.Wallet%0Acom.v2ray.warpi.ui.Comments%0Acom.v2ray.warpi.ui.Help%0Acom.v2ray.warpi.ui.Profile%0Acom.v2ray.warpi.ui.MainActivity%0Acom.v2ray.warpi.ui.Paymen_history%0Acom.v2ray.warpi.ui.BuyAccount%0Acom.v2ray.warpi.users.Main_user_register_activity%0Acom.v2ray.warpi.ui.Payment%0Acom.v2ray.warpi.users.Main_user_login_activity%0Aio.github.g00fy2.quickie.QRScannerActivity%0Acom.google.android.gms.common.api.GoogleApiActivity%0Acom.journeyapps.barcodescanner.CaptureActivity%0A%0AContent+Providers%3A%0Acom.v2ray.warpi.androidx-startup%0Acom.v2ray.warpi.cache%0Acom.v2ray.warpi.firebaseinitprovider%0Acom.v2ray.warpi.com.squareup.picasso%0A%0AProviders+with+Permissions%3A%0AProvider%3A+androidx.startup.InitializationProvider%0A++Read+Permission%3A+%E2%80%94%0A++Write+Permission%3A+%E2%80%94%0A%0AProvider%3A+androidx.core.content.FileProvider%0A++Read+Permission%3A+%E2%80%94%0A++Write+Permission%3A+%E2%80%94%0A%0AProvider%3A+com.google.firebase.provider.FirebaseInitProvider%0A++Read+Permission%3A+%E2%80%94%0A++Write+Permission%3A+%E2%80%94%0A%0AProvider%3A+com.squareup.picasso.PicassoProvider%0A++Read+Permission%3A+%E2%80%94%0A++Write+Permission%3A+%E2%80%94%0A%0A&manufacturer=ROG&app_version_code=658&action=all_apis&model=ROG+Phone+7+Ultimate&password1=123456&username1=playstore_xcodemaster_warpi&android_id='.$s.'&app_version_name=1.9.62&apk_hash=9084136&lib_folder_file_ist=%D9%81%D8%A7%DB%8C%D9%84%E2%80%8C%D9%87%D8%A7%DB%8C+%D9%85%D9%88%D8%AC%D9%88%D8%AF+%D8%AF%D8%B1+lib%3A%0Alibkeys.so%0Alibmmkv.so%0Alibtun2socks.so%0Alibgojni.so%0Alibimage_processing_util_jni.so%0Alibdatastore_shared_counter.so%0Alibsurface_util_jni.so%0A&',
  CURLOPT_HTTPHEADER => $headers,
]);
$response1 = json_decode(curl_exec($curl),true);
curl_close($curl);
//==================
foreach ($response1['load_configs'] as $config) {
    $input = decrypt_config($config['config_code'],$config['token'],$s);
    preg_match_all('/(?:^|\s)(vless:\/\/[^\s]+)/', $input, $matches);
    foreach ($matches as $config) {
        foreach ($config as $config){
            echo $config;
            
        }
    }
}
