<?php
header('Content-Type: application/json; charset=UTF-8');

// مسیر فایل‌ها
$CACHE_FILE = __DIR__ . '/cache_data.json'; // برای ذخیره کانفیگ‌ها
$STATE_FILE = __DIR__ . '/state.json';      // برای نگهداری ایندکس فعلی
$CACHE_TTL  = 30 * 60; // 30 دقیقه

// تابع دیکریپت
function decrypt_config($str) {
    return openssl_decrypt(
        base64_decode($str),
        'AES-256-CBC',
        'com.yrvpn.app9pLmQwE2zRtYhUjKlOp',
        OPENSSL_RAW_DATA,
        'com.yrvpn.appwE2'
    );
}

// تابع دریافت داده از سرور
function fetch_from_api() {
    $url = "https://khodetiokhodet.under-salamt.com/yrvpn/get.php";
    $postFields = http_build_query([
        "ac"      => "1",
        "model"   => "MI 9",
        "brand"   => "Xiaomi",
        "sdk"     => "28",
        "version" => "3.25.4"
    ]);

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL            => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => $postFields,
        CURLOPT_HTTPHEADER     => [
            "accept: */*",
            "content-type: application/x-www-form-urlencoded",
            "user-agent: okhttp/4.12.0",
            "Connection: Keep-Alive"
        ],
        CURLOPT_ENCODING       => "",
        CURLOPT_TIMEOUT        => 20,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    if (!$response) return [];

    $decoded = openssl_decrypt(
        base64_decode($response),
        'AES-256-CBC',
        'com.yrvpn.app9pLmQwE2zRtYhUjKlOp',
        OPENSSL_RAW_DATA,
        'com.yrvpn.appwE2'
    );

    $data = json_decode($decoded, true);
    $configs = [];

    if (!empty($data['config']['vpn'])) {
        foreach ($data['config']['vpn'] as $item) {
            $cfg = decrypt_config($item['config']);
            if ($cfg) $configs[] = trim($cfg);
        }
    }

    if (!empty($data['config']['ads'])) {
        foreach ($data['config']['ads'] as $item) {
            $cfg = decrypt_config($item['config']);
            if ($cfg) $configs[] = trim($cfg);
        }
    }

    return array_values(array_unique($configs));
}

// بارگذاری کش (اگر معتبر است)
function load_cache($file, $ttl) {
    if (file_exists($file)) {
        $data = json_decode(file_get_contents($file), true);
        if ($data && isset($data['time']) && time() - $data['time'] < $ttl) {
            return $data['configs'];
        }
    }
    return null;
}

// ذخیره کش
function save_cache($file, $configs) {
    file_put_contents($file, json_encode([
        'time' => time(),
        'configs' => $configs
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

// بارگذاری ایندکس چاپ فعلی
function load_state($file) {
    if (file_exists($file)) {
        $state = json_decode(file_get_contents($file), true);
        if ($state && isset($state['index'])) return $state['index'];
    }
    return 0;
}

// ذخیره ایندکس چاپ فعلی
function save_state($file, $index) {
    file_put_contents($file, json_encode(['index' => $index], JSON_PRETTY_PRINT));
}

// --- شروع اجرای اصلی ---
$configs = load_cache($CACHE_FILE, $CACHE_TTL);

if (!$configs) {
    $configs = fetch_from_api();
    if ($configs) save_cache($CACHE_FILE, $configs);
}

// اگر هیچ کانفیگی موجود نیست
if (!$configs || count($configs) === 0) {
    echo json_encode(["error" => "No configs found"]);
    exit;
}

// خواندن وضعیت فعلی
$currentIndex = load_state($STATE_FILE);
$total = count($configs);

// چاپ یک کانفیگ
echo $configs[$currentIndex] . "\n";

// برو به کانفیگ بعدی (دور چرخشی)
$nextIndex = ($currentIndex + 1) % $total;
save_state($STATE_FILE, $nextIndex);
?>