<?php

// تنظیمات کش
$cacheFile = 'cnnnache.txt'; // فایل کش
$cacheTime = 1; // 6 دقیقه

// بررسی اینکه آیا فایل کش موجود است و مدت زمان کش منقضی نشده است
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
    // بارگذاری داده‌های کش شده
    $response = file_get_contents($cacheFile);
} else {
    // دریافت داده‌ها از API
    $url = "https://fitn1.ir/Api/Yrvpn/Yr.php";
    $response = file_get_contents($url);

    if ($response === false) {
        die("خطا در دریافت داده از API");
    }

    // ذخیره داده‌ها در فایل کش
    file_put_contents($cacheFile, $response);
}

// الگوها برای انواع کانفیگ‌های لینکی
$patterns = [
    'vless'     => '/(vless:\/\/[^\s]+)/i',
    'vmess'     => '/(vmess:\/\/[^\s]+)/i',
    'trojan'    => '/(trojan:\/\/[^\s]+)/i',
    'ss'        => '/(ss:\/\/[^\s]+)/i',                 // Shadowsocks
    'ssr'       => '/(ssr:\/\/[^\s]+)/i',                // ShadowsocksR (اگر بود)
    'wireguard' => '/((?:wg|wireguard):\/\/[^\s]+)/i',   // WireGuard اگر این فرم داشته باشد
];

$configs = [];

// استخراج کانفیگ‌های لینکی بر اساس الگوها
foreach ($patterns as $pattern) {
    if (preg_match_all($pattern, $response, $matches)) {
        $configs = array_merge($configs, $matches[0]);
    }
}

/**
 * استخراج دقیق بلوک‌های JSON که واقعاً کانفیگ Xray/V2Ray هستند
 * (یعنی حداقل یکی از کلیدهای inbounds یا outbounds را داشته باشند)
 */
function extractJsonConfigs($text) {
    $results = [];
    $len = strlen($text);
    $i = 0;

    while ($i < $len) {
        $ch = $text[$i];

        // شروع یک بلوک JSON: { یا [
        if ($ch === '{' || $ch === '[') {
            $start = $i;
            $depth = 0;
            $inString = false;
            $escape = false;

            for (; $i < $len; $i++) {
                $c = $text[$i];

                if ($inString) {
                    // داخل رشته
                    if ($escape) {
                        $escape = false;
                    } else {
                        if ($c === '\\') {
                            $escape = true;
                        } elseif ($c === '"') {
                            $inString = false;
                        }
                    }
                } else {
                    // بیرون رشته
                    if ($c === '"') {
                        $inString = true;
                    } elseif ($c === '{' || $c === '[') {
                        $depth++;
                    } elseif ($c === '}' || $c === ']') {
                        $depth--;
                        if ($depth === 0) {
                            // انتهای بلوک JSON
                            $end = $i;
                            $jsonStr = substr($text, $start, $end - $start + 1);

                            // تست JSON بودن
                            $decoded = json_decode($jsonStr, true);
                            if ($decoded !== null && json_last_error() === JSON_ERROR_NONE) {
                                // فیلتر هوشمند: فقط کانفیگ‌هایی که ساختار xray/v2ray دارند
                                if (
                                    is_array($decoded) &&
                                    (isset($decoded['outbounds']) || isset($decoded['inbounds']))
                                ) {
                                    $results[] = $jsonStr; // عین خام ذخیره می‌شود
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }

        $i++;
    }

    // حذف تکراری‌ها
    if (!empty($results)) {
        $results = array_values(array_unique($results));
    }

    return $results;
}

// استخراج همه کانفیگ‌های جیسونی از متن
$jsonConfigs = extractJsonConfigs($response);

// ادغام لینک‌ها و JSONها در یک آرایه
if (!empty($jsonConfigs)) {
    $configs = array_merge($configs, $jsonConfigs);
}

// بررسی اینکه آیا داده‌ای برای پردازش وجود دارد
if (empty($configs)) {
    die("داده‌ای برای نمایش وجود ندارد");
}

// انتخاب یک کانفیگ به صورت تصادفی
$config = $configs[array_rand($configs)];

// چاپ کانفیگ (لینک یا JSON خام)
echo $config;