<?php
header('Content-type: text/plain');

// دریافت JSON از API
$url = file_get_contents('http://dragonalwaysbest.com/api/getgeneralapp/dragonnew/null/T-Mobile');
$data = json_decode($url, true);

// بررسی اینکه `config` در `serverDTO` موجود است
if (!isset($data['data']['serverDTO']['config'])) {
    die(json_encode(['error' => 'Invalid response structure']));
}

// دیکد کردن مقدار `config` که به صورت یک رشته JSON ذخیره شده است
$configJson = $data['data']['serverDTO']['config'];
$configArray = json_decode($configJson, true);

// بررسی صحت داده‌ها
if (!$configArray || !isset($configArray['outbounds'])) {
    die(json_encode(['error' => 'Invalid V2Ray configuration']));
}

// جستجو برای پروتکل `vless` در `outbounds`
$vlessConfig = null;
foreach ($configArray['outbounds'] as $outbound) {
    if ($outbound['protocol'] === 'vless') {
        $vlessConfig = $outbound;
        break;
    }
}

// بررسی وجود تنظیمات VLESS
if (!$vlessConfig || !isset($vlessConfig['settings']['vnext'][0])) {
    die(json_encode(['error' => 'No VLESS configuration found']));
}

// استخراج اطلاعات کلیدی
$vnext = $vlessConfig['settings']['vnext'][0];
$address = $vnext['address'] ?? '';
$port = $vnext['port'] ?? '';
$user = $vnext['users'][0] ?? [];

$uuid = $user['id'] ?? '';
$flow = $user['flow'] ?? '';
$security = $user['security'] ?? 'none';

// استخراج تنظیمات استریم
$streamSettings = $vlessConfig['streamSettings'] ?? [];
$network = $streamSettings['network'] ?? 'tcp';
$tls = $streamSettings['security'] ?? 'none';
$serverName = $streamSettings['tlsSettings']['serverName'] ?? '';
$wsPath = $streamSettings['wsSettings']['path'] ?? '';
$wsHost = $streamSettings['wsSettings']['headers']['Host'] ?? '';

// بررسی اطلاعات ضروری
if (empty($uuid) || empty($address) || empty($port)) {
    die(json_encode(['error' => 'Missing essential VLESS parameters']));
}

// ساخت لینک VLESS
$vlessLink = "vless://$uuid@$address:$port?security=$tls";
if (!empty($flow)) $vlessLink .= "&flow=$flow";
if (!empty($serverName)) $vlessLink .= "&sni=$serverName";
if (!empty($wsPath)) $vlessLink .= "&path=$wsPath";
if (!empty($network)) $vlessLink .= "&type=$network";
if (!empty($wsHost)) $vlessLink .= "&host=$wsHost";

// افزودن نام سرور در انتهای لینک
$vlessLink .= "#Germany";

// نمایش لینک خروجی
echo $vlessLink;
?>
