<?php
// مسیر فایل کش
$cacheFile = 'cache.json';
$cacheLifetime = 10 * 60; // 10 دقیقه به ثانیه

// اگر کش موجود است و معتبر است، از کش استفاده می‌کنیم
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheLifetime) {
    // داده‌ها را از فایل کش می‌خوانیم
    $data = json_decode(file_get_contents($cacheFile), true);
} else {
    // لینک API
    $url = 'https://fitn1.ir/Api/Jetvpn/jet.php';

    // دریافت داده‌ها از API
    $response = file_get_contents($url);
    $data = json_decode($response, true);

    // بررسی اینکه داده‌ها به درستی بارگذاری شده‌اند
    if ($data && isset($data['configs']) && is_array($data['configs'])) {
        // ذخیره داده‌ها در فایل کش
        file_put_contents($cacheFile, json_encode($data));
    } else {
        echo "داده‌ها بارگذاری نشدند یا ساختار صحیح نیست.";
        exit;
    }
}

// بررسی اینکه داده‌ها به درستی بارگذاری شده‌اند
if ($data && isset($data['configs']) && is_array($data['configs'])) {
    // تعداد کانفیگ‌ها
    $count = count($data['configs']);
    
    // انتخاب یک کانفیگ به صورت تصادفی
    $randomIndex = rand(0, $count - 1);
    $randomConfig = $data['configs'][$randomIndex];

    // چاپ کانفیگ انتخاب شده
    echo "کانفیگ انتخاب شده:\n";
    print_r($randomConfig);
} else {
    echo "داده‌ها بارگذاری نشدند یا ساختار صحیح نیست.";
}
?>
