<?php
// لینک منبع داده
$sourceUrl = "https://fitn1.ir/Api/hpg/hpgvless.php";

// دریافت داده از لینک
function getDataFromUrl($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    curl_close($ch);

    if ($response === false || empty(trim($response))) {
        return null;
    }

    return trim($response);
}

// پردازش لینک VLESS
function parseVlessLink($link) {
    if (empty($link) || strpos($link, "vless://") !== 0) {
        return null;
    }

    $link = str_replace("vless://", "", $link);
    $parts = explode("?", $link);
    $authPart = explode("@", $parts[0]);
    if (count($authPart) < 2) {
        return null;
    }

    $uuid = $authPart[0];
    list($address, $port) = explode(":", $authPart[1]);

    parse_str($parts[1] ?? '', $params);

    return [
        'uuid' => $uuid,
        'address' => $address,
        'port' => $port,
        'params' => $params
    ];
}

// تولید JSON سالم
function createJsonConfig($vlessData) {
    if (!$vlessData) {
        return null;
    }

    return [
        "remarks" => "VLess-V5-CloudFlare-Port-443-MainJSON",
        "log" => [
            "loglevel" => "warning"
        ],
        "dns" => [
            "hosts" => [
                "domain:googleapis.cn" => "googleapis.com",
                "one.one.one.one" => [
                    "1.1.1.1",
                    "1.0.0.1"
                ],
                "dns.google" => [
                    "8.8.8.8",
                    "8.8.4.4"
                ]
            ],
            "servers" => [
                "1.1.1.1",
                "1.0.0.1",
                "8.8.8.8",
                "8.8.4.4"
            ]
        ],
        "inbounds" => [
            [
                "listen" => "127.0.0.1",
                "port" => 10808,
                "protocol" => "socks",
                "settings" => [
                    "auth" => "noauth",
                    "udp" => true,
                    "userLevel" => 8
                ],
                "sniffing" => [
                    "destOverride" => ["http", "tls"],
                    "enabled" => false,
                    "routeOnly" => false
                ],
                "tag" => "socks"
            ],
            [
                "listen" => "127.0.0.1",
                "port" => 10809,
                "protocol" => "http",
                "settings" => [
                    "userLevel" => 8
                ],
                "tag" => "http"
            ]
        ],
        "outbounds" => [
            [
                "mux" => [
                    "concurrency" => 32,
                    "enabled" => true,
                    "xudpConcurrency" => 32,
                    "xudpProxyUDP443" => "reject"
                ],
                "protocol" => "vless",
                "settings" => [
                    "vnext" => [
                        [
                            "address" => $vlessData['address'], // این آدرس از لینک گرفته می‌شود
                            "port" => $vlessData['port'],
                            "users" => [
                                [
                                    "encryption" => "none",
                                    "flow" => "",
                                    "id" => $vlessData['uuid'], // استفاده از id از لینک
                                    "level" => 8,
                                    "security" => "auto"
                                ]
                            ]
                        ],
                        [
                            "address" => "sky.ns.cloudflare.com", // این آدرس ثابت می‌ماند
                            "port" => 443,
                            "users" => [
                                [
                                    "encryption" => "none",
                                    "flow" => "",
                                    "id" => $vlessData['uuid'], // استفاده از id از لینک
                                    "level" => 8,
                                    "security" => "auto"
                                ]
                            ]
                        ],
                        [
                            "address" => "isabel.ns.cloudflare.com", // این آدرس ثابت می‌ماند
                            "port" => 443,
                            "users" => [
                                [
                                    "encryption" => "none",
                                    "flow" => "",
                                    "id" => $vlessData['uuid'], // استفاده از id از لینک
                                    "level" => 8,
                                    "security" => "auto"
                                ]
                            ]
                        ]
                    ]
                ],
                "streamSettings" => [
                    "network" => "ws",
                    "security" => "tls",
                    "tlsSettings" => [
                        "allowInsecure" => false,
                        "alpn" => ["h3", "h2", "http/1.1"],
                        "fingerprint" => "chrome",
                        "publicKey" => "",
                        "serverName" => $vlessData['address'], // استفاده از serverName از لینک
                        "shortId" => "",
                        "show" => false,
                        "spiderX" => ""
                    ],
                    "wsSettings" => [
                        "headers" => [
                            "Host" => $vlessData['address'], // استفاده از Host از لینک
                            "User-Agent" => "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Mobile Safari/537.36"
                        ],
                        "path" => "/wss"
                    ],
                    "sockopt" => [
                        "TcpNoDelay" => true,
                        "mark" => 255
                    ]
                ],
                "fragment" => [
                    "interval" => "1-2",
                    "length" => "20-40",
                    "packets" => "tlshello"
                ],
                "noises" => [
                    [
                        "delay" => "10-16",
                        "packet" => "10-20",
                        "type" => "rand"
                    ]
                ],
                "tag" => "proxy"
            ],
            [
                "protocol" => "freedom",
                "settings" => [],
                "tag" => "direct"
            ],
            [
                "protocol" => "blackhole",
                "settings" => [
                    "response" => [
                        "type" => "http"
                    ]
                ],
                "tag" => "block"
            ]
        ],
        "routing" => [
            "domainStrategy" => "IPOnDemand"
        ]
    ];
}

// دریافت لینک و تولید JSON
$vlessLink = getDataFromUrl($sourceUrl);

if (empty($vlessLink)) {
    exit;
}

$vlessData = parseVlessLink($vlessLink);

if (empty($vlessData)) {
    exit;
}

$jsonConfig = createJsonConfig($vlessData);

if (empty($jsonConfig)) {
    exit;
}

header('Content-Type: application/json');
echo json_encode($jsonConfig, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
?>
