<?php
// لینک دریافت داده
$url = 'https://iran.fitn1.ir/jump.php?convert=true';

// زمان انقضا کش
$cacheTime = 62; // ثانیه

// نام کلید کش
$cacheKey = 'vless_cache';

// بررسی وجود کش
if (function_exists('apcu_fetch')) {
    $response = apcu_fetch($cacheKey, $success);
    if (!$success) {
        $response = file_get_contents($url);
        if ($response === false) {
            die('خطا در دریافت داده‌ها.');
        }
        apcu_store($cacheKey, $response, $cacheTime);
    }
} else {
    // fallback به فایل کش اگر APCu فعال نبود
    $cacheFile = __DIR__ . '/cache.json';
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
        $response = file_get_contents($cacheFile);
    } else {
        $response = file_get_contents($url);
        if ($response === false) {
            die('خطا در دریافت داده‌ها.');
        }
        file_put_contents($cacheFile, $response);
    }
}

// هر خط یک JSON هست
$lines = explode("\n", trim($response));

// استخراج لینک‌های vless
foreach ($lines as $line) {
    $line = trim($line);
    if (empty($line)) continue;

    $json = json_decode($line, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        continue;
    }

    if (isset($json['outbounds']) && is_array($json['outbounds'])) {
        foreach ($json['outbounds'] as $outbound) {
            if (isset($outbound['protocol']) && $outbound['protocol'] === 'vless') {
                if (isset($outbound['settings']['vnext'][0]['address']) &&
                    isset($outbound['settings']['vnext'][0]['port']) &&
                    isset($outbound['settings']['vnext'][0]['users'][0]['id'])) {
                    
                    $address = $outbound['settings']['vnext'][0]['address'];
                    $port = $outbound['settings']['vnext'][0]['port'];
                    $id = $outbound['settings']['vnext'][0]['users'][0]['id'];

                    $network = $outbound['streamSettings']['network'] ?? 'tcp';
                    $security = $outbound['streamSettings']['security'] ?? 'none';
                    $servername = $outbound['streamSettings']['tlsSettings']['serverName'] ?? '';

                    $params = [];

                    if (!empty($network)) {
                        $params[] = "type={$network}";
                    }
                    if (!empty($security)) {
                        $params[] = "security={$security}";
                    }
                    if (!empty($servername)) {
                        $params[] = "sni={$servername}";
                    }

                    if ($network === 'grpc') {
                        $serviceName = $outbound['streamSettings']['grpcSettings']['serviceName'] ?? '';
                        if (!empty($serviceName)) {
                            $params[] = "mode=multi";
                            $params[] = "serviceName={$serviceName}";
                        }
                    }

                    $queryString = implode("&", $params);

                    $vlessLink = "vless://{$id}@{$address}:{$port}?{$queryString}#proxy";

                    echo $vlessLink . "\n";
                }
            }
        }
    }
}
?>