<?php
header('Content-type: application/json');

$cacheFile = __DIR__ . '/cache_config.json';
$cacheTTL = 34 * 60; // 34 دقیقه

function fetchDataAndCache($cacheFile, $key) {
    $ch = curl_init("https://sufii.org/v2speed.php");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, [
        'app_code' => '4b4d3b629883bb09387d52f3785d959e',
        's' => '88fecb4f508e70878682fb6a759e8981d788a0c928af77916be4f3d6e7d512da795389852213ee4700976a368ff6bde1',
        'twain' => 'dbd9d1372d36081731c11e5b0952527be04d749691973e20b0448645aa6ab7b95adcc7b2718994f06f8f95890d739327',
        'third' => 'fb7a0c0a4b1dcba6a17989b98f5513b9',
        'fourth' => '1736009559440'
    ]);
    $res = curl_exec($ch);
    curl_close($ch);

    $decrypted = openssl_decrypt(hex2bin($res), 'AES-256-CBC', $key, OPENSSL_RAW_DATA, $key);
    if ($decrypted) {
        file_put_contents($cacheFile, $decrypted);
    }
    return $decrypted;
}

$key = hex2bin('4762545d4c706e28627b6f74336a236d4031216d726d56377a30343371397765');

if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTTL) {
    $data = file_get_contents($cacheFile);
} else {
    $data = fetchDataAndCache($cacheFile, $key);
}

if ($data) {
    $decoded = json_decode($data, true);
    $configs = $decoded['splash'] ?? [];

    if (!empty($configs)) {
        // انتخاب تصادفی یک کانفیگ از لیست
        $randomConfig = $configs[array_rand($configs)];
        echo $randomConfig['config'] . "\n";
    } else {
        echo json_encode(["error" => "No configs found"]);
    }
} else {
    echo json_encode(["error" => "Unable to fetch or decrypt data"]);
}
?>