<?php
// لینک منبع داده
$sourceUrl = "https://fitn1.ir/Api/node/trun.php?tedad=2";

// دریافت داده از لینک
function getDataFromUrl($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    curl_close($ch);

    if ($response === false || empty(trim($response))) {
        return null;
    }

    return trim($response);
}

// پردازش لینک VLESS
function parseVlessLink($link) {
    if (empty($link) || strpos($link, "vless://") !== 0) {
        return null;
    }

    // حذف بخش بعد از علامت # (اگر وجود داشته باشد)
    $link = strtok($link, '#');

    $link = str_replace("vless://", "", $link);
    $parts = explode("?", $link);
    $authPart = explode("@", $parts[0]);
    if (count($authPart) < 2) {
        return null;
    }

    $uuid = $authPart[0];
    list($address, $port) = explode(":", $authPart[1]);

    parse_str($parts[1] ?? '', $params);

    return [
        'uuid' => $uuid,
        'address' => $address,
        'port' => $port,
        'host' => $params['host'] ?? 'd1.hetzner.com',  // اگر host وجود نداشت، مقدار پیش‌فرض قرار می‌دهیم
        'path' => $params['path'] ?? ''  // اگر path وجود نداشت، مقدار پیش‌فرض "" قرار می‌دهیم
    ];
}

// تولید JSON سالم
function createJsonConfig($vlessData) {
    if (!$vlessData) {
        return null;
    }

    return [
        "dns" => [
            "hosts" => [
                "domain:googleapis.cn" => "googleapis.com"
            ],
            "servers" => [
                "1.1.1.1"
            ]
        ],
        "inbounds" => [
            [
                "listen" => "127.0.0.1",
                "port" => 10808,
                "protocol" => "socks",
                "settings" => [
                    "auth" => "noauth",
                    "udp" => true,
                    "userLevel" => 8
                ],
                "sniffing" => [
                    "destOverride" => [],
                    "enabled" => false
                ],
                "tag" => "socks"
            ],
            [
                "listen" => "127.0.0.1",
                "port" => 10809,
                "protocol" => "http",
                "settings" => [
                    "userLevel" => 8
                ],
                "tag" => "http"
            ]
        ],
        "log" => [
            "loglevel" => "error"
        ],
        "outbounds" => [
            [
                "mux" => [
                    "concurrency" => 0,
                    "enabled" => true,
                    "xudpConcurrency" => 0,
                    "xudpProxyUDP443" => "reject"
                ],
                "protocol" => "vless",
                "settings" => [
                    "vnext" => [
                        [
                            "address" => $vlessData['address'],
                            "port" => (int)$vlessData['port'],
                            "users" => [
                                [
                                    "encryption" => "none",
                                    "flow" => "",
                                    "id" => $vlessData['uuid'],
                                    "level" => 8,
                                    "security" => "auto"
                                ]
                            ]
                        ]
                    ]
                ],
                "streamSettings" => [
                    "network" => "ws",
                    "security" => "none",
                    "wsSettings" => [
                        "headers" => [
                            "Host" => $vlessData['host']  // استفاده از host استخراج شده
                        ],
                        "path" => $vlessData['path']  // استفاده از path استخراج شده بدون تغییر
                    ]
                ],
                "tag" => "proxy"
            ],
            [
                "protocol" => "freedom",
                "settings" => [],
                "tag" => "direct"
            ],
            [
                "protocol" => "blackhole",
                "settings" => [
                    "response" => [
                        "type" => "http"
                    ]
                ],
                "tag" => "block"
            ]
        ],
        "routing" => [
            "domainStrategy" => "IPIfNonMatch"
        ]
    ];
}

// دریافت لینک و تولید JSON
$vlessLink = getDataFromUrl($sourceUrl);

if (empty($vlessLink)) {
    exit;
}

$vlessData = parseVlessLink($vlessLink);

if (empty($vlessData)) {
    exit;
}

$jsonConfig = createJsonConfig($vlessData);

if (empty($jsonConfig)) {
    exit;
}

header('Content-Type: application/json');
echo json_encode($jsonConfig, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
?>
