<?php
header('Content-Type: application/json'); 

define('CACHE_FILE', 'cache.json'); // مسیر فایل کش
define('CACHE_DURATION', 1200); // مدت زمان کش (۲۰ دقیقه = ۱۲۰۰ ثانیه)

function getiv($str){
    $offset = strlen($str) - 16;
    return substr($str, $offset >> 1, 16);
}

function decrypt($encrypted_config) {
    $iv = getiv($encrypted_config);
    $decoded = base64_decode(str_replace($iv, "", $encrypted_config));
    $decrypted = openssl_decrypt($decoded, 'AES-128-CBC', "46520506c7573301", OPENSSL_RAW_DATA, $iv);
    return $decrypted;
}

function fetchDataFromAPI() {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://adi.imaginationsymphony.com/node/',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'package=freevpn.proxy.nodeplus.telegram&device_id=7A0296222086444C82AB90B95B39D0D41716727184369&os=Android_13+%2833%29&display=TP1A.220624.014+%281080x2167%29&version_code=12&locale=fa&gdi=293526219270&gai=1%3A293526219270%3Aandroid%3A8ccd43007320f1b5693187&gak=AIzaSyCAeG5ElnlfHirFKYi5ThfuR1LgEiRucow&device_name=XIAOMI+M2103K19PG%2813%29&version_name=NodeVPN+V12&build_id=FIRST_BUILD&action=app_data',
        CURLOPT_HTTPHEADER => [
            'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:108.0) Gecko/1381234 Firefox/108.0',
            'Accept-Encoding: gzip',
            'Content-Type: application/x-www-form-urlencoded',
            'Cache-Control: no-cache',
            'Accept-Language: en-US,en;q=0.5',
        ],
    ]);
    
    $response = curl_exec($curl);
    curl_close($curl);

    return decrypt($response);
}

function getCachedData() {
    if (file_exists(CACHE_FILE)) {
        $cache = json_decode(file_get_contents(CACHE_FILE), true);
        if ($cache && isset($cache['timestamp']) && (time() - $cache['timestamp'] < CACHE_DURATION)) {
            return $cache['data']; // بازگرداندن داده‌های کش شده
        }
    }
    return null; // کش نامعتبر است
}

function saveCache($data) {
    $cache = [
        'timestamp' => time(),
        'data' => $data
    ];
    file_put_contents(CACHE_FILE, json_encode($cache));
}

// دریافت داده‌ها از کش یا API
$data = getCachedData();
if (!$data) {
    $data = json_decode(fetchDataFromAPI(), true);
    if ($data) {
        saveCache($data); // ذخیره در کش
    }
}

// بررسی و انتخاب تصادفی vpn_server_config با احتمال برابر
if (isset($data['result']['free_servers']) && count($data['result']['free_servers']) > 0) {
    $servers = $data['result']['free_servers'];
    shuffle($servers); // مرتب‌سازی تصادفی لیست برای احتمال یکسان
    $random_server = $servers[0]; // انتخاب اولین مورد پس از مرتب‌سازی تصادفی

    if (isset($random_server['vpn_server_config'])) {
        $vpn_server_config = $random_server['vpn_server_config'];
        $decoded_config = base64_decode($vpn_server_config);
        echo $decoded_config . "\n\n"; // چاپ مقدار رمزگشایی شده
    }
}
?>
