<?php
header('Content-type: application/json');

$cacheFile = 'cache.json';  // مسیر فایل کش
$indexFile = 'index.txt';   // فایل برای ذخیره موقعیت فعلی
$cacheTime = 15 * 60;       // مدت زمان کش به ثانیه (15 دقیقه)
$currentTime = time();

// بررسی اینکه آیا فایل کش موجود است و مدت زمان کش منقضی نشده است
if (file_exists($cacheFile) && ($currentTime - filemtime($cacheFile)) < $cacheTime) {
    // داده‌ها از کش خوانده می‌شود
    $response = json_decode(file_get_contents($cacheFile), true);
} else {
    // داده‌ها از API دریافت می‌شود
    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://orbnet.link/graphql',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => '{"operationName":null,"variables":{"sortBy":"spot","parameter":""},"query":"query fetchServerList($sortBy: String!, $parameter: String!) {\\n  getClientSortedServers(sortBy: $sortBy, parameter: $parameter) {\\n    id\\n    hostName\\n    publicIp\\n    city\\n    country\\n    description\\n    hero\\n    spot\\n    zeus\\n    connectedUserCount\\n    continent\\n    congestionLevel\\n    bridgeCountry\\n    bridgeIp\\n  }\\n}"}',
        CURLOPT_HTTPHEADER => ['User-Agent: okhttp/3.14.9', 'Connection: Keep-Alive', 'Accept: application/json', 'Content-Type: application/json', 'Accept-Language: ', 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJleHAiOjI3MzAzMDkxMDMsImlhdCI6MTczMDMwOTEwMywidXNlcm5hbWUiOiJhbGxlbnNoaW5lMTk5NkBnbWFpbC5jb20ifQ.oH1Py5EYb10xinj_Z3Yc4loi9LePxe2MOwDpYm70iv8'],
    ]);

    $response = json_decode(curl_exec($curl), true);

    curl_close($curl);

    // ذخیره داده‌های جدید در فایل کش
    file_put_contents($cacheFile, json_encode($response));
}

// استخراج لیست سرورها
$servers = $response['data']['getClientSortedServers'];

// بررسی اینکه آیا فایل index.txt موجود است یا نه (برای ذخیره وضعیت آخرین چاپ)
$index = 0;
if (file_exists($indexFile)) {
    $index = (int)file_get_contents($indexFile);  // خواندن وضعیت آخرین سرور چاپ شده
}

// چاپ کانفیگ فعلی
if (isset($servers[$index])) {
    print($servers[$index]['spot']) . "\n";
    print($servers[$index]['hero']) . "\n";
}

// ذخیره وضعیت فعلی در فایل index.txt (برای چاپ سرور بعدی در دفعه بعد)
$index = ($index + 1) % count($servers);  // اگر به انتهای لیست رسید، به ابتدا برمی‌گردد
file_put_contents($indexFile, $index);  // ذخیره موقعیت جدید
?>
