<?php
// ================== تنظیمات عمومی ==================
error_reporting(0);
header('Content-Type: text/plain; charset=utf-8');
date_default_timezone_set('GMT');

// کش 60 دقیقه‌ای
define('CACHE_FILE', __DIR__ . '/cache_v2_confhhjigs.json');
define('CACHE_TTL', 60 * 60); // 60 دقیقه

// در صورت نیاز هاست را برای xhttp override کن؛ یا null بگذار تا دست‌نخورده بماند
$HOST_OVERRIDE = null; // مثلا: 's5.nexagates.com'

// ================== توابع کمکی عمومی ==================
function rand_ip() {
    return sprintf('%d.%d.%d.%d', mt_rand(1,254), mt_rand(0,255), mt_rand(0,255), mt_rand(1,254));
}
function xorStrings($a,$b){
    $r=''; $la=strlen($a); $lb=strlen($b);
    if(!$la || !$lb) return $r;
    $m=max($la,$lb);
    for($i=0;$i<$m;$i++) $r.=chr(ord($a[$i%$la])^ord($b[$i%$lb]));
    return $r;
}
function lencheck($s){ $j=0; for($i=0;$i<strlen($s);$i++) $j+=ord($s[$i])*($i+1); return (string)$j; }
function generateRandomString(){ $c='0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; $L=strlen($c); $n=mt_rand(10,59); $s=''; for($i=0;$i<$n;$i++) $s.=$c[rand(0,$L-1)]; return $s; }
function generateUUID(){ return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',mt_rand(0,0xffff),mt_rand(0,0xffff),mt_rand(0,0xffff),mt_rand(0,0x0fff)|0x4000,mt_rand(0,0x3fff)|0x8000,mt_rand(0,0xffff),mt_rand(0,0xffff),mt_rand(0,0xffff)); }
function ae2i_a(array &$o,string $iB,string $kB,int $s){ for($i=0;$i<$s;$i++){ for($j=0;$j<$s;$j++){ $o[$i][$j]=(ord($iB[$i%strlen($iB)])*ord($kB[$j%strlen($kB)]))&0xFF; } } return "done"; }
function encryptKey1(string $strA){ $hour=(int)date("G"); $bArr=pack("N",$hour); $iMax=max(strlen($strA),strlen($bArr)); $iArr=array_fill(0,$iMax,array_fill(0,$iMax,0)); ae2i_a($iArr,$strA,$bArr,$iMax); $b=''; for($i=0;$i<$iMax;$i++){ for($j=0;$j<$iMax;$j++) $b.=chr($iArr[$i][$j]); } return base64_encode($b); }

// ================== توابع رمزنگاری API ==================
function decrypt_payload($str) {
    if ($str === null || $str === '') return '';
    $dateStr = gmdate("Ymd");
    $xorValue = 6510615555426900570;
    $computed = ((int)$dateStr ^ $xorValue) % 1000000007;
    $valueStr = (string)$computed;
    $constStr = "tyjLkSZm";
    $keyBuilder = '';
    for ($i=0,$j=0; $i<strlen($constStr) || $j<strlen($valueStr);) {
        if ($i < strlen($constStr)) $keyBuilder .= $constStr[$i++];
        if ($j < strlen($valueStr)) $keyBuilder .= $valueStr[$j++];
    }
    $key = (strlen($keyBuilder) > 16) ? substr($keyBuilder,0,16) : str_pad($keyBuilder,16,'0');

    $decoded = base64_decode($str, true);
    if ($decoded === false) return '';

    $source="!@#$%^&*()-=_+abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    $target="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()-=_+";
    $arr = preg_split('//u', $decoded, -1, PREG_SPLIT_NO_EMPTY);
    foreach ($arr as $k=>$ch) {
        $idx = strpos($source,$ch);
        if ($idx!==false) $arr[$k] = $target[$idx];
    }
    foreach ($arr as $k=>$ch) $arr[$k] = chr(ord($ch) ^ ord('Z'));
    for ($i=count($arr)-1;$i>=0;$i--){
        $swap = (($i*7)+3)%count($arr);
        [$arr[$i],$arr[$swap]] = [$arr[$swap],$arr[$i]];
    }
    $str4 = implode('', $arr);

    $aesInput = base64_decode($str4, true);
    if ($aesInput === false) return '';
    $dec = openssl_decrypt($aesInput, 'AES-128-ECB', $key, OPENSSL_RAW_DATA);
    if ($dec === false) return '';

    $arr2 = preg_split('//u', $dec, -1, PREG_SPLIT_NO_EMPTY);
    foreach ($arr2 as $k=>$ch) {
        $idx = strpos($source,$ch);
        if ($idx!==false) $arr2[$k] = $target[$idx];
    }
    foreach ($arr2 as $k=>$ch) $arr2[$k] = chr(ord($ch) ^ ord('Z'));
    for ($i=count($arr2)-1;$i>=0;$i--){
        $swap = (($i*7)+3)%count($arr2);
        [$arr2[$i],$arr2[$swap]] = [$arr2[$swap],$arr2[$i]];
    }
    return implode('', $arr2);
}
function encrypt_payload($str,$str2){
    $day=(int)gmdate('d');
    $hash=hash('sha256',(string)$day,true);
    $str3=bin2hex($hash);
    $strA=xorStrings(xorStrings($str2,$str3),"ysBLwXVXcxa9A7F9s9g");
    $key=substr(hash('sha256',$strA,true),0,16);
    $i5=$day+100;
    $bArr3=random_bytes($i5);
    $bArr4=random_bytes(100);
    $bytes2=mb_convert_encoding($str,'UTF-8');
    $bArr7='';
    for($i=0;$i<strlen($bytes2);$i++) $bArr7.=chr(ord($bytes2[$i])^ord($bArr3[$i%$i5]));
    $bArr8=''; $j=0;
    for($i=0;$i<strlen($bArr7)*2;$i++) $bArr8.=($i%2==0 && $j<strlen($bArr7)) ? $bArr7[$j++] : $bArr4[$i%100];
    $bArr9=$bArr3.$bArr8;
    $cipher=openssl_encrypt($bArr9,'AES-128-ECB',$key,OPENSSL_RAW_DATA);
    if($cipher===false) return '';
    $bArr11='';
    for($i=0;$i<strlen($cipher);$i++) $bArr11.=chr(ord($cipher[$i])^ord($str2[$i%strlen($str2)]));
    $bArr12='';
    for($i=0;$i<strlen($bArr11);$i++) $bArr12.=chr(ord($bArr11[$i])^strlen($str2));
    $bArr13=random_bytes(100);
    $bArr14=''; $j=0;
    for($i=0;$i<strlen($bArr12)*2;$i++) $bArr14.=($i%2==0 && $j<strlen($bArr12)) ? $bArr12[$j++] : $bArr13[$i%100];
    $arr=str_split($bArr14);
    for($i=0;$i<count($arr);$i++){ $s=$i+8; if($s<count($arr)) [$arr[$i],$arr[$s]]=[$arr[$s],$arr[$i]]; }
    return base64_encode(implode('',$arr));
}

// ================== نرمال‌سازی v2rayNG (SplitHTTP/XHTTP) ==================
function normalizeV2RayNg(string $json, ?string $hostOverride=null): ?string {
    $d = json_decode($json, true);
    if (!is_array($d) || !isset($d['outbounds']) || !is_array($d['outbounds'])) return null;

    foreach ($d['outbounds'] as &$ob) {
        if (!isset($ob['streamSettings']) || !is_array($ob['streamSettings'])) continue;
        if (($ob['streamSettings']['network'] ?? null) !== 'xhttp') continue;

        if ($hostOverride) {
            if (!isset($ob['streamSettings']['tlsSettings']) || !is_array($ob['streamSettings']['tlsSettings'])) {
                $ob['streamSettings']['tlsSettings'] = [];
            }
            $ob['streamSettings']['tlsSettings']['serverName'] = $hostOverride;
        }

        if (!isset($ob['streamSettings']['xhttpSettings']) || !is_array($ob['streamSettings']['xhttpSettings'])) {
            $ob['streamSettings']['xhttpSettings'] = [];
        }
        if ($hostOverride) {
            $ob['streamSettings']['xhttpSettings']['host'] = $hostOverride;
        }

        // headers → object {} و حذف host
        $headersObj = new stdClass();
        if (isset($ob['streamSettings']['xhttpSettings']['headers'])) {
            $h = $ob['streamSettings']['xhttpSettings']['headers'];
            if (is_array($h)) {
                $filtered=[];
                foreach ($h as $k=>$v) if (strcasecmp($k,'host')!==0) $filtered[$k]=$v;
                if (!empty($filtered)) $headersObj = json_decode(json_encode($filtered));
            }
        }
        $ob['streamSettings']['xhttpSettings']['headers'] = $headersObj;

        // type correction
        if (isset($ob['streamSettings']['xhttpSettings']['scMaxEachPostBytes'])) {
            $ob['streamSettings']['xhttpSettings']['scMaxEachPostBytes'] = (int)$ob['streamSettings']['xhttpSettings']['scMaxEachPostBytes'];
        }
        foreach (['path','scStreamUpServerSecs','xPaddingBytes'] as $k) {
            if (isset($ob['streamSettings']['xhttpSettings'][$k])) {
                $ob['streamSettings']['xhttpSettings'][$k] = (string)$ob['streamSettings']['xhttpSettings'][$k];
            }
        }
        if (isset($ob['streamSettings']['tlsSettings']['alpn']) && !is_array($ob['streamSettings']['tlsSettings']['alpn'])) {
            $ob['streamSettings']['tlsSettings']['alpn'] = [(string)$ob['streamSettings']['tlsSettings']['alpn']];
        }
    }
    unset($ob);

    // 🔧 تضمین سازگاری: stats باید object باشد (نه آرایه/رشته)
    if (!isset($d['stats']) || !is_array($d['stats'])) {
        $d['stats'] = new stdClass();
    } else {
        $isAssoc = count(array_filter(array_keys($d['stats']), 'is_string')) > 0;
        if (!$isAssoc) {
            $d['stats'] = new stdClass();
        }
    }

    return json_encode($d, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
}

// ================== کش خوانی/نوشتن امن ==================
function load_cache() {
    if (!file_exists(CACHE_FILE)) return null;
    $fp = @fopen(CACHE_FILE, 'r');
    if (!$fp) return null;
    @flock($fp, LOCK_SH);
    $txt = stream_get_contents($fp);
    @flock($fp, LOCK_UN);
    @fclose($fp);
    $j = json_decode($txt, true);
    if (!is_array($j) || !isset($j['ts']) || !isset($j['data'])) return null;
    if (time() - (int)$j['ts'] > CACHE_TTL) return null;
    return $j;
}
function save_cache($data, $nextIdx = 0) {
    $payload = json_encode([
        'ts' => time(),
        'data' => $data,
        'next_idx' => (int)$nextIdx
    ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
    $fp = @fopen(CACHE_FILE, 'c+');
    if (!$fp) return;
    @flock($fp, LOCK_EX);
    ftruncate($fp, 0);
    fwrite($fp, $payload);
    fflush($fp);
    @flock($fp, LOCK_UN);
    @fclose($fp);
}

// ================== دریافت داده (با کش) ==================
function fetch_data_with_cache() {
    $cache = load_cache();
    if ($cache !== null) return $cache;

    $ip = rand_ip();
    $uuid = generateUUID();
    $minute = date('i');
    $base = gmp_init(bin2hex($uuid), 16);
    $exponent = gmp_init($minute);
    $modulus = gmp_init('115792089237316195423570985008687907853269984665640564039457584007913129319283');
    $encodedModPow = base64_encode(gmp_powm($base, $exponent, $modulus));

    $body = json_encode([
        generateRandomString() => generateRandomString(),
        "Nonce" => $uuid,
        "VersionName" => "1.1",
        "VersionCode" => "20250708",
        "key1" => encryptKey1($uuid),
        "key2" => $encodedModPow
    ], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);

    $checkid = lencheck($body);
    $payload = encrypt_payload($body, $checkid);
    if ($payload === '') return null;

    $url = "https://ghalishoii.com/api/v1/b316d5b2-74b1-4748-a5d5-aea6492a23eb";
    $headers = [
        'check: '.$checkid,
        'Content-Type: application/json; charset=utf-8',
        'User-Agent: okhttp/4.10.0',
        'CLIENT-IP: '.$ip,
        'X-FORWARDED-FOR: '.$ip
    ];
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CONNECTTIMEOUT => 12,
        CURLOPT_TIMEOUT => 25,
        CURLOPT_SSL_VERIFYPEER => true,
    ]);
    $rawResp = curl_exec($ch);
    if ($rawResp === false) {
        curl_close($ch);
        return null;
    }
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($code < 200 || $code >= 300) return null;

    $respArr = json_decode($rawResp, true);
    if (!is_array($respArr) || !isset($respArr['data'])) return null;

    $dec = decrypt_payload($respArr['data']);
    if ($dec === '') return null;

    $data = json_decode($dec, true);
    if (!is_array($data)) return null;

    save_cache($data, 0);
    return load_cache();
}

// ================== اجرای اصلی: انتخاب تک‌کانفیگ به‌صورت چرخه‌ای ==================
$cache = fetch_data_with_cache();
if (!$cache) {
    exit;
}

$data = $cache['data'];
$nextIdx = isset($cache['next_idx']) ? (int)$cache['next_idx'] : 0;

// ساخت لیست خطی از همهٔ پیکربندی‌ها: Configs_app + Configs_sp
$items = [];
if (isset($data['Configs_sp']) && is_array($data['Configs_sp'])) {
    foreach ($data['Configs_sp'] as $it) {
        if (isset($it['config_content'])) $items[] = $it['config_content'];
    }
}

// اگر لیست خالی بود
if (empty($items)) {
    exit;
}

// انتخاب چرخه‌ای: اندیس = nextIdx % count
$idx = $nextIdx % count($items);
$selected = $items[$idx];

// nextIdx را افزایش بده و در کش بنویس تا نوبت بعدی پیکربندی بعدی چاپ شود
$nextIdx++;
save_cache($data, $nextIdx);

// نهایی‌سازی خروجی: اگر JSONِ کانفیگ است → نرمال‌سازیِ v2rayNG؛ وگرنه خام
$out = normalizeV2RayNg($selected, $HOST_OVERRIDE);
echo ($out !== null ? $out : $selected) . "\n";

exit;