<?php
header('Content-type: application/json');

// تابع رمزگشایی AES
function decryptAES($str, $str2) {
    $cipher = "AES-128-CBC";
    $key = substr($str2, 0, 16);
    $iv = substr($str2, 0, 16);
    $decrypted = openssl_decrypt(base64_decode($str), $cipher, $key, OPENSSL_RAW_DATA, $iv);
    
    if ($decrypted === false) {
        return "Error in Decryption";
    }
    
    return $decrypted;
}

// فایل کش و مدت زمان کش
$cacheFile = 'cache.json'; // نام فایل کش
$cacheTime = 13; // مدت زمان اعتبار کش (ثانیه)

// اگر کش معتبر باشد، داده‌ها را از کش بخوانید
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
    $cachedData = json_decode(file_get_contents($cacheFile), true);
    if ($cachedData && isset($cachedData['data']) && count($cachedData['data']) > 0) {
        // انتخاب تصادفی یکی از داده‌های کش
        $s = $cachedData['data'][mt_rand(0, count($cachedData['data']) - 1)];
        $server = decryptAES($s['value'], 'key_' . $s['id']);
        echo $server;
        exit;
    }
}

// در صورت نبود کش معتبر، داده‌ها را از API بگیرید
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://panalapps.com/api/protocols/Android',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ['sign: WiC9k2iyHUVAGm/r+ZF8yA=='],
]);

$response = curl_exec($curl);
curl_close($curl);

// بررسی صحت داده‌های دریافت‌شده
$responseData = json_decode($response, true);
if (!$responseData || !isset($responseData['data']) || count($responseData['data']) === 0) {
    echo json_encode(["error" => "Failed to fetch data or invalid response"]);
    exit;
}

// ذخیره داده‌ها در فایل کش (استفاده از قفل فایل برای جلوگیری از دسترسی همزمان)
$cacheHandle = fopen($cacheFile, 'c'); // فایل را با قابلیت نوشتن و قفل باز می‌کنیم
if (flock($cacheHandle, LOCK_EX)) {  // قفل فایل برای نوشتن
    file_put_contents($cacheFile, json_encode($responseData));  // ذخیره داده‌ها
    flock($cacheHandle, LOCK_UN);  // باز کردن قفل پس از نوشتن
} else {
    echo json_encode(["error" => "Unable to lock cache file"]);
    exit;
}
fclose($cacheHandle);

// انتخاب تصادفی یکی از داده‌ها
$s = $responseData['data'][mt_rand(0, count($responseData['data']) - 1)];

// رمزگشایی داده انتخاب شده
$server = decryptAES($s['value'], 'key_' . $s['id']);

// چاپ خروجی
echo $server;
