<?php
header('Content-type: application/json');

$cacheFile = 'cache.json';
$cacheTime = 13; // مدت زمان اعتبار کش (ثانیه)

// اگر کش معتبر باشد، داده‌ها را از کش بخوانید
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
    $cachedData = file_get_contents($cacheFile);
    echo $cachedData; // چاپ کل دادهٔ کش
    exit;
}

// در صورت نبود کش معتبر، داده‌ها را از API بگیرید
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://panalapps.com/api/protocols/Android',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ['sign: WiC9k2iyHUVAGm/r+ZF8yA=='],
]);

$response = curl_exec($curl);
curl_close($curl);

// بررسی صحت داده‌ها
if (!$response) {
    echo json_encode(["error" => "Failed to fetch data"]);
    exit;
}

// ذخیره در کش
file_put_contents($cacheFile, $response);

// چاپ کل دادهٔ خام
echo $response;