<?php
header('Content-Type: application/json; charset=utf-8');

$SECRET = 'MY_SUPER_SECRET_123';
$BASE = __DIR__;

$ts = (int)($_GET['ts'] ?? 0);
$token = (string)($_GET['token'] ?? '');

$expect = hash_hmac('sha256', (string)$ts, $SECRET);
if (!$ts || !hash_equals($expect, $token) || abs(time() - $ts) > 120) {
  http_response_code(403);
  echo json_encode(['ok'=>false,'error'=>'forbidden'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
  exit;
}

$files = [];
$it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($BASE, FilesystemIterator::SKIP_DOTS));
foreach ($it as $f) {
  if (!$f->isFile()) continue;
  $abs = $f->getPathname();
  $rel = ltrim(str_replace('\\','/', substr(str_replace('\\','/',$abs), strlen(str_replace('\\','/',$BASE)))), '/');
  if ($rel === 'sync_manifest.php' || $rel === 'sync_get.php') continue;

  $files[] = [
    'path'  => $rel,
    'size'  => filesize($abs),
    'mtime' => filemtime($abs),
    'sha1'  => sha1_file($abs),
  ];
}

echo json_encode(['ok'=>true,'time'=>time(),'files'=>$files], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);