<?php

// گرفتن IP واقعی کاربر
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ipList[0]);
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// دریافت اطلاعات ISP از API رایگان ip-api.com
function getISP($ip) {
    $json = @file_get_contents("http://ip-api.com/json/$ip?fields=isp,org,as,query");
    if ($json === false) {
        return "Unknown ISP";
    }
    $data = json_decode($json, true);
    return $data['isp'] ?? "Unknown ISP";
}

// تشخیص Device + OS + Browser از User-Agent
function getDeviceInfo() {
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';

    // Browser
    if (preg_match('/Chrome/i', $ua)) $browser = 'Chrome';
    elseif (preg_match('/Firefox/i', $ua)) $browser = 'Firefox';
    elseif (preg_match('/Safari/i', $ua)) $browser = 'Safari';
    elseif (preg_match('/Edge/i', $ua)) $browser = 'Edge';
    elseif (preg_match('/Opera|OPR/i', $ua)) $browser = 'Opera';
    else $browser = 'Unknown';

    // OS
    if (preg_match('/Windows/i', $ua)) $os = 'Windows';
    elseif (preg_match('/Android/i', $ua)) $os = 'Android';
    elseif (preg_match('/iPhone|iPad/i', $ua)) $os = 'iOS';
    elseif (preg_match('/Linux/i', $ua)) $os = 'Linux';
    elseif (preg_match('/Mac OS/i', $ua)) $os = 'MacOS';
    else $os = 'Unknown';

    // Device Type
    if (preg_match('/Mobile/i', $ua)) $device = "Mobile";
    elseif (preg_match('/Tablet/i', $ua)) $device = "Tablet";
    else $device = "Desktop";

    return [
        "browser" => $browser,
        "os" => $os,
        "device" => $device
    ];
}

$ip = getUserIP();
$isp = getISP($ip);
$info = getDeviceInfo();

echo "IP: $ip<br>";
echo "ISP: $isp<br>";
echo "Device: {$info['device']}<br>";
echo "OS: {$info['os']}<br>";
echo "Browser: {$info['browser']}<br>";

// ذخیره در فایل
$logFile = __DIR__ . '/ip_log.txt';
$time = date("Y-m-d H:i:s");

$log = "[$time] IP: $ip | ISP: $isp | Device: {$info['device']} | OS: {$info['os']} | Browser: {$info['browser']}\n";

file_put_contents($logFile, $log, FILE_APPEND | LOCK_EX);

?>