<?php
// URL لینک API
$url = "https://fitn1.ir/Api/titan/tit.php";

// دریافت داده‌ها از لینک با cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10); // زمان انتظار
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // زمان انتظار اتصال
$response = curl_exec($ch);
$error = curl_error($ch);
curl_close($ch);

// بررسی خطاهای cURL
if (!$response) {
    die("خطا در دریافت داده‌ها از لینک: $error");
}

// بررسی فرمت داده‌ها
if (strpos($response, 'Array') !== false) {
    // تبدیل آرایه چاپ‌شده به آرایه PHP
    $response = str_replace(["\n", "\r", "Array", "(", ")", "=>"], ["", "", "", "[", "]", ":"], $response);
    $data = eval("return " . $response . ";");
} else {
    die("خطا: فرمت داده‌های دریافتی پشتیبانی نمی‌شود.");
}

// بررسی صحت آرایه
if (!is_array($data)) {
    die("خطا: داده‌های دریافت‌شده به آرایه PHP تبدیل نشدند.");
}

// ساختار JSON نهایی
$jsonOutput = [
    "dns" => [
        "hosts" => [],
        "servers" => []
    ],
    "fakedns" => [],
    "inbounds" => [
        [
            "port" => 10808,
            "protocol" => "socks",
            "settings" => [
                "auth" => "noauth",
                "udp" => true,
                "userLevel" => 8
            ],
            "sniffing" => [
                "destOverride" => ["http", "tls", "fakedns"],
                "enabled" => true,
                "routeOnly" => true
            ],
            "tag" => "socks"
        ],
        [
            "listen" => "127.0.0.1",
            "port" => 10853,
            "protocol" => "dokodemo-door",
            "settings" => [
                "address" => "1.1.1.1",
                "network" => "tcp,udp",
                "port" => 53
            ],
            "tag" => "dns-in"
        ]
    ],
    "log" => [
        "loglevel" => "warning"
    ],
    "outbounds" => [
        [
            "mux" => [
                "concurrency" => -1,
                "enabled" => false,
                "xudpConcurrency" => 8,
                "xudpProxyUDP443" => ""
            ],
            "protocol" => "vmess",
            "settings" => [
                "vnext" => [
                    [
                        "address" => $data['add'] ?? '',
                        "port" => (int)($data['port'] ?? 0),
                        "users" => [
                            [
                                "id" => $data['id'] ?? '',
                                "level" => 8,
                                "security" => $data['scy'] ?? ''
                            ]
                        ]
                    ]
                ]
            ],
            "streamSettings" => [
                "grpcSettings" => [
                    "authority" => "",
                    "health_check_timeout" => 20,
                    "idle_timeout" => 60,
                    "multiMode" => false,
                    "serviceName" => ""
                ],
                "network" => $data['net'] ?? '',
                "security" => $data['tls'] ?? '',
                "tlsSettings" => [
                    "allowInsecure" => true,
                    "alpn" => isset($data['alpn']) ? explode(",", $data['alpn']) : [],
                    "serverName" => $data['sni'] ?? '',
                    "show" => false
                ]
            ],
            "tag" => "proxy"
        ],
        [
            "protocol" => "freedom",
            "settings" => [
                "domainStrategy" => "UseIP"
            ],
            "tag" => "direct"
        ],
        [
            "protocol" => "blackhole",
            "settings" => [
                "response" => [
                    "type" => "http"
                ]
            ],
            "tag" => "block"
        ],
        [
            "protocol" => "dns",
            "tag" => "dns-out"
        ]
    ],
    "policy" => [
        "levels" => [
            "8" => [
                "connIdle" => 300,
                "downlinkOnly" => 1,
                "handshake" => 4,
                "uplinkOnly" => 1
            ]
        ],
        "system" => [
            "statsOutboundUplink" => true,
            "statsOutboundDownlink" => true
        ]
    ],
    "remarks" => $data['ps'] ?? '',
    "routing" => [
        "domainStrategy" => "IPIfNonMatch",
        "rules" => [
            [
                "inboundTag" => ["dns-in"],
                "outboundTag" => "dns-out",
                "type" => "field"
            ]
        ]
    ],
    "stats" => []
];

// چاپ JSON نهایی
header('Content-Type: application/json');
echo json_encode($jsonOutput, JSON_PRETTY_PRINT);
?>
