<?php
// تابع برای دریافت داده‌ها از لینک و دیکد کردن base64
function getVmessData($url) {
    // دریافت داده از لینک
    $rawData = file_get_contents($url);
    
    if (!$rawData) {
        die("Error: Unable to fetch data from the URL.");
    }

    // دیکد کردن داده base64
    $decodedData = base64_decode(str_replace('vmess://', '', $rawData));
    
    if (!$decodedData) {
        die("Error: Invalid vmess URL.");
    }

    // تبدیل داده دیکد شده به JSON
    $jsonData = json_decode($decodedData, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        die("Error: Invalid JSON data.");
    }

    return $jsonData;
}

// URL مورد نظر برای دریافت داده
$url = 'https://fitn1.ir/Api/titan/trun.php';

// دریافت و پردازش داده‌ها
$data = getVmessData($url);

// نمایش فقط آرایه به صورت خالص
print_r($data);
?>
