<?php
// لینک منبع داده
$sourceUrl = "https://fitn1.ir/Api/ttt/ttt.php";

// دریافت داده از لینک
function getDataFromUrl($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);
    curl_close($ch);

    if ($response === false || empty(trim($response))) {
        return null;  // اگر داده‌ای دریافت نشد یا خالی بود
    }

    return trim($response);
}

// پردازش لینک VLESS
function parseVlessLink($link) {
    if (empty($link) || strpos($link, "vless://") !== 0) {
        return null; // اگر لینک نامعتبر باشد
    }

    $link = str_replace("vless://", "", $link);
    $parts = explode("?", $link);
    $authPart = explode("@", $parts[0]);
    if (count($authPart) < 2) {
        return null; // اگر ساختار لینک نادرست باشد
    }

    $uuid = $authPart[0];
    list($address, $port) = explode(":", $authPart[1]);

    parse_str($parts[1] ?? '', $params);

    return [
        'uuid' => $uuid,
        'address' => $address,
        'port' => $port,
        'params' => $params
    ];
}

// تولید JSON سالم
function createJsonConfig($vlessData) {
    if (!$vlessData) {
        return null; // اگر داده‌ها نامعتبر باشند
    }

    return [
        "log" => [
            "loglevel" => "warning"
        ],
        "inbounds" => [
            [
                "listen" => "0.0.0.0",
                "port" => 10808,
                "protocol" => "socks",
                "settings" => [
                    "auth" => "noauth",
                    "udp" => true,
                    "userLevel" => 8
                ],
                "sniffing" => [
                    "enabled" => true,
                    "destOverride" => ["http", "tls"],
                    "routeOnly" => false
                ],
                "tag" => "socks"
            ],
            [
                "listen" => "0.0.0.0",
                "port" => 10809,
                "protocol" => "http",
                "settings" => [
                    "userLevel" => 8
                ],
                "tag" => "http"
            ]
        ],
        "outbounds" => [
            [
                "protocol" => "vless",
                "tag" => "proxy",
                "mux" => [
                    "enabled" => true,
                    "concurrency" => 16,
                    "xudpConcurrency" => 8,
                    "xudpProxyUDP443" => ""
                ],
                "settings" => [
                    "vnext" => [
                        [
                            "address" => $vlessData['address'],
                            "port" => (int)$vlessData['port'],
                            "users" => [
                                [
                                    "id" => $vlessData['uuid'],
                                    "encryption" => $vlessData['params']['encryption'] ?? "none",
                                    "flow" => $vlessData['params']['flow'] ?? "",
                                    "level" => 8,
                                    "security" => "auto"
                                ]
                            ]
                        ]
                    ]
                ],
                "streamSettings" => [
                    "network" => $vlessData['params']['type'] ?? "tcp",
                    "security" => $vlessData['params']['security'] ?? "reality",
                    "realitySettings" => [
                        "publicKey" => $vlessData['params']['pbk'] ?? "",
                        "serverName" => $vlessData['params']['sni'] ?? "",
                        "shortId" => $vlessData['params']['sid'] ?? "",
                        "fingerprint" => $vlessData['params']['fp'] ?? "",
                        "allowInsecure" => true
                    ],
                    "tcpSettings" => [
                        "header" => [
                            "type" => "none"
                        ]
                    ]
                ]
            ],
            [
                "protocol" => "freedom",
                "tag" => "direct",
                "settings" => [
                    "domainStrategy" => "UseIP"
                ]
            ],
            [
                "protocol" => "blackhole",
                "tag" => "block",
                "settings" => [
                    "response" => [
                        "type" => "http"
                    ]
                ]
            ]
        ],
        "dns" => [
            "hosts" => [
                "google.com" => "8.8.8.8",
                "google-analytics.com" => "8.8.8.8",
                "admob.com" => "8.8.8.8",
                "doubleclick.net" => "8.8.8.8",
                "adservice.google.com" => "8.8.8.8",
                "googlesyndication.com" => "8.8.8.8",
                "facebook.com" => "8.8.8.8",
                "fbcdn.net" => "8.8.8.8",
                "connect.facebook.net" => "8.8.8.8",
                "ads.yahoo.com" => "8.8.8.8",
                "media.net" => "8.8.8.8",
                "openx.net" => "8.8.8.8",
                "adroll.com" => "8.8.8.8",
                "exponential.com" => "8.8.8.8",
                "rubiconproject.com" => "8.8.8.8",
                "amazon-adsystem.com" => "8.8.8.8",
                "msn.com" => "8.8.8.8",
                "bing.com" => "8.8.8.8",
                "linkedin.com" => "8.8.8.8",
                "ad.linkedin.com" => "8.8.8.8",
                "twitter.com" => "8.8.8.8",
                "t.co" => "8.8.8.8",
                "syndication.twitter.com" => "8.8.8.8",
                "geosite:category-ads-all" => "0.0.0.0",
                "domain:googleapis.cn" => "googleapis.com",
            ],
            "cache" => [
                "enabled" => true,
                "strategy" => "lru",
                "cacheSize" => 5,
                "cacheDuration" => 10
            ],
            "servers" => [
                "1.1.1.1",
                [
                    "address" => "1.1.1.1",
                    "domains" => [
                        "domain:googleapis.cn",
                        "domain:gstatic.com"
                    ]
                ],
                [
                    "address" => "223.5.5.5",
                    "domains" => [
                        "domain:dns.alidns.com",
                        "domain:doh.pub",
                        "domain:dot.pub",
                        "domain:doh.360.cn",
                        "domain:dot.360.cn",
                        "geosite:cn",
                        "geosite:geolocation-cn"
                    ],
                    "expectIPs" => [
                        "geoip:cn"
                    ],
                    "skipFallback" => true
                ]
            ]
        ],
        "policy" => [
            "levels" => [
                "8" => [
                    "connIdle" => 60,
                    "uplinkOnly" => 
                    10,
                    "downlinkOnly" => 
                    10,
                    "handshake" => 10
                ]
            ],
            "system" => [
                "statsOutboundUplink" => false,
                "statsOutboundDownlink" => false
            ]
        ],
        "routing" => [
            "domainStrategy" => "Asls",
            "rules" => [
                [
                    "ip" => ["1.1.1.1"],
                    "outboundTag" => "proxy",
                    "port" => "53",
                    "type" => "field"
                ],
                [
                    "type" => "field",
                    "outboundTag" => "direct",
                    "domain" => [
                        "geosite:private",
                        "full:www.msftncsi.com",
                        "full:www.msftconnecttest.com",
                        "full:connectivitycheck.gstatic.com",
                        "full:connectivitycheck.android.com",
                        "livechatinc.com",
                        "livesys.org",
                        "nodelink.me"
                    ]
                ]
            ]
        ],
        "remarks" => $vlessData['params']['remark'] ?? "server",
        "stats" => new stdClass()
    ];
}

// دریافت لینک و تولید JSON
$vlessLink = getDataFromUrl($sourceUrl);

// اگر لینک خالی است یا مشکلی در دریافت داده وجود داشت، هیچ چیزی چاپ نمی‌شود
if (empty($vlessLink)) {
    exit; // هیچ چیزی چاپ نمی‌شود
}

// پردازش داده‌های VLESS
$vlessData = parseVlessLink($vlessLink);

// اگر داده‌ها صحیح نباشند، هیچ چیزی چاپ نمی‌شود
if (empty($vlessData)) {
    exit; // هیچ چیزی چاپ نمی‌شود
}

// تولید و چاپ خروجی JSON
$jsonConfig = createJsonConfig($vlessData);

// اگر داده‌ها به درستی پردازش نشوند، هیچ چیزی چاپ نمی‌شود
if (empty($jsonConfig)) {
    exit; // هیچ چیزی چاپ نمی‌شود
}

header('Content-Type: application/json');
echo json_encode($jsonConfig, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
?>
