<?php
header('Content-type: application/json');

function decryptAES($str, $str2) {
    $cipher = "AES-128-CBC";
    $key = substr($str2, 0, 16);
    $iv = substr($str2, 0, 16);
    $decrypted = openssl_decrypt(base64_decode($str), $cipher, $key, OPENSSL_RAW_DATA, $iv);
    
    if ($decrypted === false) {
        return "Error in Decryption";
    }
    return $decrypted;
}

function getCachedData($cacheFile, $updateInterval) {
    if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $updateInterval) {
        // Return cached data if valid
        return json_decode(file_get_contents($cacheFile), true);
    } else {
        // Fetch new data and update cache
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://managev1.xyz/api/protocols/Android',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => ['sign: qNlqRzohVs9L+SfRx3CA2Q=='],
        ]);
        
        $response = curl_exec($curl);
        curl_close($curl);
        
        if ($response === false) {
            return [];
        }
        
        $data = json_decode($response, true);
        if (isset($data['data'])) {
            file_put_contents($cacheFile, json_encode($data));
        }
        return $data;
    }
}

function getRandomConfig($data) {
    if (empty($data['data'])) {
        return "No configuration available";
    }
    $randomKey = array_rand($data['data']);
    return $data['data'][$randomKey];
}

// Define cache file and update interval (10 minutes)
$cacheFile = __DIR__ . '/cache.json';
$updateInterval = 600; // 10 minutes in seconds

// Get cached or fresh data
$data = getCachedData($cacheFile, $updateInterval);

// Get a random configuration
$randomConfig = getRandomConfig($data);

if (isset($randomConfig['value'], $randomConfig['id'])) {
    $decryptedConfig = decryptAES($randomConfig['value'], 'key_' . $randomConfig['id']);
    echo $decryptedConfig . "\n";
} else {
    echo "Invalid configuration data\n";
}
?>
