<?php
header('Content-type: application/json');

// کش کردن داده‌ها و زمان آخرین آپدیت
$cacheFile = 'cache.json';
$cacheTime = 15 * 60; // 15 دقیقه
$currentTime = time();

// اگر فایل کش وجود داشته باشد
if (file_exists($cacheFile)) {
    $cacheData = json_decode(file_get_contents($cacheFile), true);
    // اگر کش قدیمی است، داده‌ها را به‌روز رسانی می‌کنیم
    if ($currentTime - $cacheData['timestamp'] > $cacheTime) {
        $data = updateCache();
        file_put_contents($cacheFile, json_encode($data));
    } else {
        $data = $cacheData['data'];
    }
} else {
    // اگر کش وجود ندارد، آن را ایجاد می‌کنیم
    $data = updateCache();
    file_put_contents($cacheFile, json_encode(['timestamp' => $currentTime, 'data' => $data]));
}

function updateCache() {
    // درخواست جدید از سرور
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://lib2023.site/vping/load_data.php',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'activity_name=MainActivity&token_key_temp=24fcbca2c46b388aab11ccd116100bb48c1a123e7551a5c3c5130ffecf33913c&os_version=11&token_key=pAd4dd32Ssarr1&hajmi=&manufacturer=Genymobile&app_version_code=613&action=all_apis&model=Pixel&password1=123456&username1=playstore_xcodemaster&android_id=9e2bef49b4b4f369&app_version_name=1.9.19',
        CURLOPT_HTTPHEADER => [
            'User-Agent: Dalvik/2.1.0 (Linux; U; Android 11; Pixel Build/RQ1A.210105.003)',
            'Connection: Keep-Alive',
            'Accept-Encoding: gzip',
            'Content-Type: application/x-www-form-urlencoded',
            'Content-Type: application/x-www-form-urlencoded; charset=UTF-8',
        ],
    ]);

    $response = json_decode(curl_exec($curl), true);
    $configs = $response['load_configs'];
    $formattedConfigs = [];

    // تبدیل کانفیگ‌ها به فرمت مناسب
    foreach ($configs as $server) {
        $text = preg_replace('/^1(ss|vless):\/\//', '$1://', $server['config_code']);
        $formattedConfigs[] = jsonserver($text);
    }

    return $formattedConfigs;
}

function jsonserver($vlessJson, $name = 'nima') { 
    $decoded_data = json_decode($vlessJson); 
    if ($decoded_data !== null) {
        $data = json_decode($vlessJson, true); 
        $protocol = $data['outbounds'][0]['protocol']; 
        $uuid = $data['outbounds'][0]['settings']['vnext'][0]['users'][0]['id']; 
        $address = $data['outbounds'][0]['settings']['vnext'][0]['address']; 
        $port = $data['outbounds'][0]['settings']['vnext'][0]['port']; 
        $security = $data['outbounds'][0]['streamSettings']['security']; 
        $tlsSni = $data['outbounds'][0]['streamSettings']['tlsSettings']['serverName'];
        $alpn = $data['outbounds'][0]['streamSettings']['tlsSettings']['alpn']; 
        $type = $data['outbounds'][0]['streamSettings']['network']; 
        $host = $data['outbounds'][0]['streamSettings']['wsSettings']['headers']['Host']; 
        $path = $data['outbounds'][0]['streamSettings']['wsSettings']['path']; 
        #ریالتی
        $realitySettings = $data['outbounds'][0]['streamSettings']['realitySettings'];
        $allowInsecure = $realitySettings['allowInsecure']; 
        $fingerprint = $realitySettings['fingerprint']; 
        $publicKey = $realitySettings['publicKey']; 
        $tlsSni = $realitySettings['serverName']; 
        $shortId = $realitySettings['shortId']; 
        $spiderX = $realitySettings['spiderX']; 
        if ($protocol == 'vless') {
            $v2ary_vless = "vless://$uuid@$address:$port?security=$security&encryption=none&pbk=$publicKey&headerType=none&fp=$fingerprint&type=$type&sni=$tlsSni&sid=$shortId#".$data['remarks'];
            return $v2ary_vless." \n";
        } else {
            $data = base64_encode(json_encode(["add" => $address, "aid" => "0", "alpn" => "", "fp" => $fingerprint, "host" => null, "id" => $uuid, "net" => $type, "path" => $path, "port" => $port, "ps" => $data['remarks'], "scy" => "auto", "sni" => $tlsSni, "tls" => "reality", "type" => "http", "v" => "2"], true));
            return $data." \n";
        }
    } else { 
        return $vlessJson."  \n\n";
    }
}

// چاپ کانفیگ تصادفی
$randomConfig = $data[array_rand($data)];
echo $randomConfig;
?>
