<?php
header('Content-Type: text/plain');

// مسیر فایل کش
$cacheFile = __DIR__ . '/cache.json';
// زمان انقضای کش (ثانیه)
$cacheExpiry = 180;

// بررسی کش
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheExpiry) {
    // اگر کش معتبر باشد، داده‌ها از فایل کش خوانده می‌شود
    $data = json_decode(file_get_contents($cacheFile), true);
} else {
    // درخواست جدید به API
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://xrayvpn.net/corev2/codes/get/?uuid=9e2bef49b4b4f369&method=aes-256-gcm',
        CURLOPT_RETURNTRANSFER => true,
    ]);
    $data = json_decode(curl_exec($curl), true);
    curl_close($curl);

    // ذخیره داده‌ها در فایل کش
    file_put_contents($cacheFile, json_encode($data));
}

// اگر داده‌ها معتبر نباشد، اسکریپت خطا می‌دهد
if (empty($data['data']['servers'])) {
    echo "No server data available.\n";
    exit;
}

// انتخاب تصادفی یکی از کانفیگ‌ها
$servers = $data['data']['servers'];
$randomKey = array_rand($servers);
$serverDetails = $servers[$randomKey];

// پاک کردن کلمات اضافی از خروجی
$output = preg_replace('/\s+/', ' ', trim($serverDetails['code_plain']));

// چاپ کانفیگ انتخاب شده
echo $output . "\n";
?>
