<?php
// config.php
declare(strict_types=1);

return [
  'DEFAULTS' => [
    'http_timeout'       => 8,
    'connect_timeout'    => 3,
    'tls_handshake'      => true,
    'cache_ttl_dns'      => 600,
    'cache_ttl_asn'      => 3600,
    'cache_ttl_config'   => 3600,
    'poll_interval'      => 10,
    'min_per_dc'         => 3,      // ✅ فقط اگر تعداد یک DC >= 3 باشد برایش فایل جدا بساز
  ],

  'PATHS' => [
    'BASE'       => __DIR__,
    'APP'        => __DIR__ . '/app',
    'DATA_DIR'   => __DIR__ . '/data',
    'OUT_DIR'    => __DIR__ . '/out',
    'LOG_DIR'    => __DIR__ . '/logs',
    'LINKS'      => __DIR__ . '/data/links.json',
    'SETTINGS'   => __DIR__ . '/data/settings.json',
    'SUMMARY'    => __DIR__ . '/data/summary.json',
    'CACHE_DIR'  => __DIR__ . '/data/cache',
    'CACHE_DNS'  => __DIR__ . '/data/cache/dns',
    'CACHE_ASN'  => __DIR__ . '/data/cache/asn',
    'CACHE_CFG'  => __DIR__ . '/data/cache/configs',
    'PID'        => __DIR__ . '/data/daemon.pid',
    'DAEMON_LOG' => __DIR__ . '/logs/daemon.log',
  ],

  // ✅ دیتاسنترهای بیشتر (ASN/Org-based regex)
  'DC_MAP' => [
    'digitalocean' => '/digital\s*ocean|do\s*llc|as14061/i',
    'hetzner'      => '/hetzner|as24940/i',
    'aws'          => '/amazon|aws|ec2|as16509|cloudfront/i',
    'ovh'          => '/ovh|as16276/i',
    'gcore'        => '/gcore|as199524|as202422/i',
    'google'       => '/google|as15169|google\s*cloud/i',
    'azure'        => '/microsoft|azure|as8075/i',
    'linode'       => '/linode|akamai.*technologies|as63949/i',
    'alibaba'      => '/alibaba|alicloud|as45102/i',
    'upcloud'      => '/upcloud|as202053/i',
    'contabo'      => '/contabo|as51167/i',
    'vultr'        => '/choopa|vultr|as20473/i',
    'leaseweb'     => '/leaseweb|as60781|as16265/i',
    'cloudflare'   => '/cloudflare|as13335/i',
    'fastly'       => '/fastly|as54113/i',
    'digitaledge'  => '/digital\s*edge|as138915/i',
    'equinix'      => '/equinix/i',
    'hivelocity'   => '/hivelocity|as29802/i',
    'ionos'        => '/1&1|ionos|as8560/i',
    'datacamp'     => '/datacamp|as60068/i',
    'cdnetworks'   => '/cdnetworks|as36408/i',
    'rackspace'    => '/rackspace|as33070/i',
    'verizon'      => '/verizon.*business|as701/i',
    'akamai'       => '/akamai|as20940/i',
  ],

  // ✅ تشخیص از روی hostname/CNAME (domain-based)
  'HOSTNAME_MAP' => [
    'cloudflare' => '/(\.cloudflare\.com|\.cf-ipfs\.com|workers\.dev|cf-dns)/i',
    'aws'        => '/(\.amazonaws\.com|cloudfront\.net)/i',
    'google'     => '/(\.google\.com|\.googleusercontent\.com|\.gvt\d?\.com)/i',
    'azure'      => '/(\.azure\.com|\.azureedge\.net|\.windows\.net)/i',
    'fastly'     => '/(\.fastly\.net|fpb\.fastlyedge\.com)/i',
    'akamai'     => '/(\.akamai(?:hd)?\.net|akadns\.net)/i',
    'gcore'      => '/(\.gcorelabs\.com|\.gcdn\.co)/i',
    'ovh'        => '/(\.ovh\.net)/i',
    'hetzner'    => '/(\.hetzner\.de|\.your-server\.de)/i',
    'digitalocean'=> '/(\.digitaloceanspaces\.com)/i',
    'linode'     => '/(\.linodeusercontent\.com)/i',
    'alibaba'    => '/(\.aliyuncs\.com)/i',
    'vultr'      => '/(\.vultrusercontent\.com)/i',
    'leaseweb'   => '/(\.leasewebcdn\.com)/i',
  ],

  // ✅ رزیدنتال: regex + لیست ASN
  'RESIDENTIAL_REGEX' => '/(mobile|mci|irancell|rightel|telecom|isp|broadband|communications|cellular|adsl|ftth|fiber|home|residential|cable|dsl)/i',
  'RESIDENTIAL_ASN' => [
    // این‌ها مثال‌اند؛ بر اساس نیاز خودت تکمیل کن
    12880,  // Iran Telecom (مثال)
    44244,  // Irancell (مثال)
    57218,  // Rightel (مثال)
  ],
  'HOSTING_ASN' => [
    16509,15169,8075,24940,13335,54113,20473,45102,16276,63949,60781,14061,202422,199524
  ],
];