<?php
// daemon.php — حلقه خودکار بدون کرون
declare(ticks=1);
$cfg = require __DIR__ . '/config.php';
require __DIR__ . '/app/bot.php';

$paths = $cfg['PATHS']; ensure_dirs($paths);
$pidfile = $paths['PID']; $logfile = $paths['DAEMON_LOG'];

if (file_exists($pidfile)) {
  $old = (int)@file_get_contents($pidfile);
  if ($old > 0 && function_exists('posix_kill') && @posix_kill($old, 0)) {
    echo "Daemon already running (PID $old)\n"; exit;
  }
}
$pid = getmypid(); @file_put_contents($pidfile, (string)$pid);
if (!is_dir(dirname($logfile))) @mkdir(dirname($logfile), 0775, true);

if (function_exists('pcntl_signal')) {
  pcntl_signal(SIGTERM, function() use($pidfile){ @unlink($pidfile); exit; });
  pcntl_signal(SIGINT,  function() use($pidfile){ @unlink($pidfile); exit; });
}

echo "Daemon started PID=$pid\n";
while (true) {
  $settings = load_json($paths['SETTINGS'], $cfg['DEFAULTS']);
  $poll = max(1, (int)($settings['poll_interval'] ?? $cfg['DEFAULTS']['poll_interval']));
  try {
    $sum = run_once($cfg);
    $line = sprintf("[%s] inputs=%d unique=%d groups=%s\n",
      date('Y-m-d H:i:s'), $sum['inputs'] ?? 0, $sum['unique_endpoints'] ?? 0, json_encode($sum['groups'] ?? []));
    @file_put_contents($logfile, $line, FILE_APPEND);
  } catch (\Throwable $e) {
    @file_put_contents($logfile, "[".date('Y-m-d H:i:s')."] ERROR: ".$e->getMessage()."\n", FILE_APPEND);
  }
  $sleep=$poll;
  while($sleep>0){ sleep(1); $sleep--; if(function_exists('pcntl_signal_dispatch')) pcntl_signal_dispatch(); }
}